 /**
  * keine Klasse, hier wurden lediglich die ntigen Buffer der gezeichneten
  * Elemente ausgelagert
  * 
  * 
  */


function initBuffers() {
	   //VertexPositionBuffer fr den BoidKrper
		boidBodyVertexPositionBuffer = gl.createBuffer();
		gl.bindBuffer(gl.ARRAY_BUFFER, boidBodyVertexPositionBuffer);	
		var boidBody = [
			0.1,-0.12,0.0,
			0.1,0.12,0.0,
			-0.5,0.3,0.0,
			-0.5,-0.3,0.0
			];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(boidBody), gl.STATIC_DRAW);
        boidBodyVertexPositionBuffer.itemSize = 3;
        boidBodyVertexPositionBuffer.numItems = 4;
		
        
        //VertexPositionBuffer fr den BoidKopf
		boidHeadVertexPositionBuffer = gl.createBuffer();
		gl.bindBuffer(gl.ARRAY_BUFFER, boidHeadVertexPositionBuffer);
		var boidHead = [
			0.5,0.0,0.0,
			0.1,0.12,0.0,
			0.1,-0.12,0.0
			];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(boidHead), gl.STATIC_DRAW);
        boidHeadVertexPositionBuffer.itemSize = 3;
        boidHeadVertexPositionBuffer.numItems = 3;
    	
        
        //TexurkoordinatenBuffer fr Boids (taugt auch allgemein fr Dreiecke)
		boidVertexTextureCoordBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ARRAY_BUFFER, boidVertexTextureCoordBuffer);
		var boidTextureCoords = [
          1.0, 0.5,
          0.0, 1.0,
          0.0, 0.0
	  	];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(boidTextureCoords), gl.STATIC_DRAW);
        boidVertexTextureCoordBuffer.itemSize = 2;
        boidVertexTextureCoordBuffer.numItems = 3;
        
		boidBodyVertexTextureCoordBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ARRAY_BUFFER, boidBodyVertexTextureCoordBuffer);
		var boidBodyTextureCoords = [
          1.0, 0.2,
          1.0, 0.8,
          0.0, 1.0,
          0.0, 0.0
	  	];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(boidBodyTextureCoords), gl.STATIC_DRAW);
        boidBodyVertexTextureCoordBuffer.itemSize = 2;
        boidBodyVertexTextureCoordBuffer.numItems = 4;
        
        var near = theGrid.gridBorderNear;
        var far = theGrid.gridBorderFar;
        
        
        //Bodenflche
        sceenerySurfacePositionBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ARRAY_BUFFER, sceenerySurfacePositionBuffer);
        var sceenerySurface = [
                               far[0], far[1], far[2],
                               near[0], far[1], far[2],
                               near[0], near[1], far[2],
                               far[0], near[1], far[2]                               
                               ];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(sceenerySurface), gl.STATIC_DRAW);
		sceenerySurfacePositionBuffer.itemSize = 3;
		sceenerySurfacePositionBuffer.numItems = 4;
        
        
        defaultQuadTextureCoordBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ARRAY_BUFFER, defaultQuadTextureCoordBuffer);
        var defaultQuadTextureCoords = [
										0.0, 0.0,
										1.0, 0.0,
										1.0, 1.0,
										0.0, 1.0                                        
                                        ];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(defaultQuadTextureCoords), gl.STATIC_DRAW);
		defaultQuadTextureCoordBuffer.itemSize = 2;
		defaultQuadTextureCoordBuffer.numItems = 4;
        
        defaultQuadIndexBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, defaultQuadIndexBuffer);
        var quadIndices = [
                           0, 1, 2,
                           0, 2, 3
                           ];
        gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array(quadIndices), gl.STATIC_DRAW);
        defaultQuadIndexBuffer.itemSize = 1;
        defaultQuadIndexBuffer.numItems = 6;
        
        
        //Wnde
        wallsVertexPositionBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ARRAY_BUFFER, wallsVertexPositionBuffer);
        var walls = [
                     near[0], near[1], far[2],
                     near[0], far[1], far[2],
                     near[0], far[1], near[2], //Ostwand
                     near[0], near[1], near[2],
                     
                     far[0], near[1], far[2],
                     near[0], near[1], far[2],
                     near[0], near[1], near[2], //Nordwand
                     far[0], near[1], near[2],
                     
                     far[0], far[1], far[2],
                     far[0], near[1], far[2],
                     far[0], near[1], near[2], //Westwand
                     far[0], far[1], near[2],
                     
                     near[0], far[1], far[2],
                     far[0], far[1], far[2],
                     far[0], far[1], near[2], //Sdwand
                     near[0], far[1], near[2]
                     ];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(walls), gl.STATIC_DRAW);
		wallsVertexPositionBuffer.itemSize = 3;
		wallsVertexPositionBuffer.numItems = 16;
		
		wallsTextureCoordBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ARRAY_BUFFER, wallsTextureCoordBuffer);
        var wallsTextureCoords = [
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0,
                                  
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0,
                                  
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0,
                                  
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0
                                  ];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(wallsTextureCoords), gl.STATIC_DRAW);
		wallsTextureCoordBuffer.itemSize = 2;
		wallsTextureCoordBuffer.numItems = 16;
		
		wallsIndexBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, wallsIndexBuffer);
        var wallsIndex = [
                          0, 1, 2,      0, 2, 3, 
                          4, 5, 6,      4, 6, 7, 
                          8, 9, 10,     8, 10, 11,
                          12, 13, 14,   12, 14, 15
                          ];
        gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array(wallsIndex), gl.STATIC_DRAW);
        wallsIndexBuffer.itemSize = 1;
        wallsIndexBuffer.numItems = 24;

        //Hindernisse - nur Textur und Indexbuffer allgmein - VertexPositionBuffer separat
        obstacleTextureCoordBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ARRAY_BUFFER, obstacleTextureCoordBuffer);
        var obstacleTextureCoords = [
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0,
                                  
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0,
                                  
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0,
                                  
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0,
                                  
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0,
                                  
                                  0.0, 0.0,
                                  1.0, 0.0,
                                  1.0, 1.0,
                                  0.0, 1.0
                                  ];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(obstacleTextureCoords), gl.STATIC_DRAW);
		obstacleTextureCoordBuffer.itemSize = 2;
		obstacleTextureCoordBuffer.numItems = 24;
		
		obstacleIndexBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, obstacleIndexBuffer);
        var obstacleIndex = [
                          0, 1, 2,      0, 2, 3, 
                          4, 5, 6,      4, 6, 7, 
                          8, 9, 10,     8, 10, 11,
                          12, 13, 14,   12, 14, 15,
                          16, 17, 18,	16, 18, 19,
                          20, 21, 22,	20, 22, 23
                          ];
        gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array(obstacleIndex), gl.STATIC_DRAW);
        obstacleIndexBuffer.itemSize = 1;
        obstacleIndexBuffer.numItems = 36;
        
        if(obstaclesEnabled){
        
        	obstacles[0] = new Obstacle([-10,-10,-10], 10, 1, 'obstacle1');
        	obstacles[0].placeIntoGrid();
        	obstacleVertexPositionBuffers[0] = obstacles[0].createVertexPositionBuffer();
    	
        	obstacles[1] = new Obstacle([10,10,10], 4, 2, 'obstacle2');
        	obstacles[1].placeIntoGrid();
        	obstacleVertexPositionBuffers[1] = obstacles[1].createVertexPositionBuffer();
        }
    }